% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cycle.R
\name{add_cycle}
\alias{add_cycle}
\title{Add a cycle of nodes to the graph}
\usage{
add_cycle(graph, n, type = NULL, label = TRUE, rel = NULL, ...)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of nodes comprising the cycle.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node cycle.}

\item{...}{optional node attributes supplied as
vectors.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node cycle to the graph.
}
\examples{
# Create a new graph and add a cycle of nodes to it
graph <-
  create_graph() \%>\%
  add_cycle(n = 6)

# Get node information from this graph
node_info(graph)
#>   id type label deg indeg outdeg loops
#> 1  1 <NA>     1   2     1      1     0
#> 2  2 <NA>     2   2     1      1     0
#> 3  3 <NA>     3   2     1      1     0
#> 4  4 <NA>     4   2     1      1     0
#> 5  5 <NA>     5   2     1      1     0
#> 6  6 <NA>     6   2     1      1     0

# Attributes can be specified in extra
# arguments and these are applied in order;
# Usually these attributes are applied to
# nodes (e.g., `type` is a node attribute)
# but the `rel` attribute will apply to the
# edges
graph_w_attrs <-
  create_graph() \%>\%
  add_cycle(
    n = 6,
    label = c("one", "two",
              "three", "four",
              "five", "six"),
    type = c("a", "a",
             "b", "b",
             "c", "c"),
    value = c(1.2, 8.4,
              3.4, 5.2,
              6.1, 2.6),
    rel = "cycle")

# Get the graph's node data frame
get_node_df(graph_w_attrs)
#>   id type label value
#> 1  1    a   one   1.2
#> 2  2    a   two   8.4
#> 3  3    b three   3.4
#> 4  4    b  four   5.2
#> 5  5    c  five   6.1
#> 6  6    c   six   2.6

# Get the graph's edge data frame
get_edge_df(graph_w_attrs)
#>   id from to   rel
#> 1  1    1  2 cycle
#> 2  2    2  3 cycle
#> 3  3    3  4 cycle
#> 4  4    4  5 cycle
#> 5  5    5  6 cycle
#> 6  6    6  1 cycle
}
