% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_edge_count_ws.R
\name{cache_edge_count_ws}
\alias{cache_edge_count_ws}
\title{Cache a count of edges (available in a
selection) in the graph}
\usage{
cache_edge_count_ws(graph, name = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{name}{an optional name for the cached vector.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, get a count of edges available in
a selection and cache that value in the graph for
later retrieval using \code{get_cache}.

Selections of edges can be performed using
the following \code{select_...} functions:
\code{select_edges()},
\code{select_last_edge()}, or
\code{select_edges_by_node_id()}.
Selections of edges can also be performed using
the following traversal functions:
\code{trav_out_edge()}, \code{trav_in_edge()},
or \code{trav_both_edge()}.
}
\examples{
# Create a graph with 5 nodes and 4 edges
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Cache a count of edges after creating a selection
graph <-
  graph \%>\%
  select_edges_by_node_id(nodes = 2) \%>\%
  cache_edge_count_ws(name = "edge_count")

# Get the number of edges stored in the cache
graph \%>\%
  get_cache(name = "edge_count")
#> [1] 2
}
