% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mutual_node_pairs.R
\name{count_mutual_node_pairs}
\alias{count_mutual_node_pairs}
\title{Get the number of mutally-connected node pairs}
\usage{
count_mutual_node_pairs(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value representing the
number of mutually-connected node pairs.
}
\description{
Get the number of mutally-connected
node pairs. This works for directed graphs.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Get a count of mutally-connected
# node pairs
count_mutual_node_pairs(graph)
#> [1] 0

# Create a full graph and then
# count the mutally-connected
# node pairs
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  count_mutual_node_pairs()
#> [1] 45
}
