% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_count.R
\name{node_count}
\alias{node_count}
\title{Get count of all nodes or certain types of nodes}
\usage{
node_count(graph, type = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{type}{either a logical value, where
\code{TRUE} provides a named vector of node count by
type and \code{FALSE} (the default) provides a total
count, or, a character vector of \code{type} values
to filter the node count.}
}
\value{
a numeric vector of single length.
}
\description{
From a graph object of class
\code{dgr_graph}, get a count of nodes in the graph
and optionally obtain a count of nodes by their type.
}
\examples{
# Set a seed
set.seed(23)

# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 26,
    label = TRUE,
    type = c(rep("a", 7),
             rep("b", 9),
             rep("c", 8),
             rep("d", 2)))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = sample(1:26, replace = TRUE),
    to = sample(1:26, replace = TRUE),
    rel = c(rep("rel_a", 7),
            rep("rel_b", 9),
            rep("rel_c", 8),
            rep("rel_d", 2)))

# Create a graph using the ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Get counts of nodes grouped by the
# `type` attribute
node_count(graph, type = TRUE)
#> a b c d
#> 7 9 8 2

# Get a total count of nodes with no grouping
node_count(graph, type = FALSE)
#> [1] 26

# Get a count of nodes of a specified type
node_count(graph, type = "a")
#> [1] 7

# Get a count of nodes of 2 different types
node_count(graph, type = c("a", "c"))
#> [1] 15
}
