% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_edge_attrs.R
\name{mutate_edge_attrs}
\alias{mutate_edge_attrs}
\title{Mutate a set of edge attribute values}
\usage{
mutate_edge_attrs(graph, ...)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{...}{Expressions used for the mutation of edge attributes. LHS of each
expression is either an existing or new edge attribute name. The RHS can
consist of any valid R code that uses edge attributes as variables.
Expressions are evaluated in the order provided, so, edge attributes
created or modified are ready to use in subsequent expressions.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal edge data frame (edf), mutate numeric edge
attribute values using one or more expressions.
}
\examples{
# Create a graph with 3 edges
graph <-
  create_graph() \%>\%
  add_path(n = 4) \%>\%
  set_edge_attrs(
    edge_attr = width,
    values = c(3.4, 2.3, 7.2))

# Get the graph's internal edf
# to show which edge attributes
# are available
graph \%>\% get_edge_df()

# Mutate the `width` edge
# attribute, dividing each
# value by 2
graph <-
  graph \%>\%
  mutate_edge_attrs(
    width = width / 2)

# Get the graph's internal
# edf to show that the edge
# attribute `width` had its
# values changed
graph \%>\% get_edge_df()

# Create a new edge attribute,
# called `length`, that is the
# log of values in `width` plus
# 2 (and, also, round all values
# to 2 decimal places)
graph <-
  graph \%>\%
  mutate_edge_attrs(
    length = (log(width) + 2) \%>\%
               round(2))

# Get the graph's internal edf
# to show that the edge attribute
# values had been mutated
graph \%>\% get_edge_df()

# Create a new edge attribute
# called `area`, which is the
# product of the `width` and
# `length` attributes
graph <-
  graph \%>\%
  mutate_edge_attrs(
    area = width * length)

# Get the graph's internal edf
# to show that the edge attribute
# values had been multiplied
# together (with new attr `area`)
graph \%>\% get_edge_df()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
