% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_simple.R
\name{is_graph_simple}
\alias{is_graph_simple}
\title{Is the graph a simple graph?}
\usage{
is_graph_simple(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A logical value.
}
\description{
Determine whether the graph is a simple graph. A simple graph is one that
does not contain any loops nor any multiple edges.
}
\examples{
# Create a graph with 2 cycles
graph <-
  create_graph() \%>\%
  add_cycle(n = 4) \%>\%
  add_cycle(n = 3)

# Check if the graph is simple
graph \%>\% is_graph_simple()

}
