% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fully_disconnect_nodes_ws.R
\name{fully_disconnect_nodes_ws}
\alias{fully_disconnect_nodes_ws}
\title{Fully disconnect all nodes in a selection of nodes}
\usage{
fully_disconnect_nodes_ws(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a selection of nodes in a graph, remove any edges to or from those
nodes.
}
\details{
This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create an empty graph and
# add a path of 6 nodes
graph <-
  create_graph() \%>\%
  add_path(n = 6)

# Select nodes `3` and `4`
# and fully disconnect them
# from the graph
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = 3:4) \%>\%
  fully_disconnect_nodes_ws()

# Get the graph's edge data frame
graph \%>\% get_edge_df()

}
