% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_ndfs.R
\name{combine_ndfs}
\alias{combine_ndfs}
\title{Combine multiple node data frames}
\usage{
combine_ndfs(...)
}
\arguments{
\item{...}{Two or more node data frames, which contain node IDs and
associated attributes.}
}
\value{
A combined node data frame.
}
\description{
Combine several node data frames into a single node data frame.
}
\examples{
# Create two node data frames
node_df_1 <-
  create_node_df(
    n = 2,
    type = c("a", "b"),
    label = c("D", "Z"),
    value = c(8.4, 3.4))

node_df_2 <-
  create_node_df(
    n = 2,
    type = c("b", "c"),
    label = c("U", "A"),
    value = c(0.4, 3.4))

# Combine the ndfs using the
# `combine_ndfs()` function
node_df_combined <-
  combine_ndfs(
    node_df_1,
    node_df_2)

# Inspect the combined ndf
node_df_combined

}
