% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{is_in.mesh}
\alias{is_in.mesh}
\title{Checks if some point belongs to a given mesh}
\usage{
is_in.mesh(x, mesh)
}
\arguments{
\item{x}{point to check}

\item{mesh}{mesh identifying the set which X may belong}
}
\description{
Checks if some point belongs to a given mesh
}
\examples{
is_in.mesh(-0.5,mesh=geometry::delaunayn(matrix(c(0,1),ncol=1),output.options =TRUE))
is_in.mesh(0.5,mesh=geometry::delaunayn(matrix(c(0,1),ncol=1),output.options =TRUE))

x =matrix(-.5,ncol=2,nrow=1)
is_in.mesh(x,mesh=geometry::delaunayn(matrix(c(0,0,1,1,0,0),ncol=2),output.options =TRUE))

x =matrix(.5,ncol=2,nrow=1)
is_in.mesh(x,mesh=geometry::delaunayn(matrix(c(0,0,1,1,0,0),ncol=2),output.options =TRUE))
}
