% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{mesh_exsets}
\alias{mesh_exsets}
\title{Search excursion set of nD function, sampled by a mesh}
\usage{
mesh_exsets(
  f,
  f.vectorized = FALSE,
  threshold,
  sign,
  intervals,
  mesh = "seq",
  mesh.sizes = 11,
  maxerror_f = 1e-09,
  tol = .Machine$double.eps^0.25,
  ex_filter.tri = all,
  ...
)
}
\arguments{
\item{f}{Function to inverse at 'threshold'}

\item{f.vectorized}{is f already vectorized ? (default: no)}

\item{threshold}{target value to inverse}

\item{sign}{focus at conservative for above (sign=1) or below (sign=-1) the threshold}

\item{intervals}{bounds to inverse in, each column contains min and max of each dimension}

\item{mesh}{function or "unif" or "seq" (default) to preform interval partition}

\item{mesh.sizes}{number of parts for mesh (duplicate for each dimension if using "seq")}

\item{maxerror_f}{maximal tolerance on f precision}

\item{tol}{the desired accuracy (convergence tolerance on f arg).}

\item{ex_filter.tri}{boolean function to validate a geometry::tri as considered in excursion : 'any' or 'all'}

\item{...}{parameters to forward to mesh_roots(...) call}
}
\description{
Search excursion set of nD function, sampled by a mesh
}
\examples{
# mesh_exsets(function(x) x, threshold=.51, sign=1, intervals=rbind(0,1),
#   maxerror_f=1E-2,tol=1E-2) # for faster testing
# mesh_exsets(function(x) x, threshold=.50000001, sign=1, intervals=rbind(0,1),
#   maxerror_f=1E-2,tol=1E-2) # for faster testing
# mesh_exsets(function(x) sum(x), threshold=.51,sign=1, intervals=cbind(rbind(0,1),rbind(0,1)),
#   maxerror_f=1E-2,tol=1E-2) # for faster testing
# mesh_exsets(sin,threshold=0,sign="sup",interval=c(pi/2,5*pi/2),
#   maxerror_f=1E-2,tol=1E-2) # for faster testing

if (identical(Sys.getenv("NOT_CRAN"), "true")) { # too long for CRAN on Windows

  e = mesh_exsets(function(x) (0.25+x[1])^2+(0.5+x[2])^2 ,
                threshold =0.25,sign=-1, intervals=matrix(c(-1,1,-1,1),nrow=2),
                maxerror_f=1E-2,tol=1E-2) # for faster testing

  plot(e$p,xlim=c(-1,1),ylim=c(-1,1));
  apply(e$tri,1,function(tri) polygon(e$p[tri,],col=rgb(.4,.4,.4,.4)))

  if (requireNamespace("rgl")) {
    e = mesh_exsets(function(x) (0.5+x[1])^2+(-0.5+x[2])^2+(0.+x[3])^2,
                  threshold = .25,sign=-1, mesh="unif",
                  intervals=matrix(c(-1,1,-1,1,-1,1),nrow=2),
                  maxerror_f=1E-2,tol=1E-2) # for faster testing

    rgl::plot3d(e$p,xlim=c(-1,1),ylim=c(-1,1),zlim=c(-1,1));
    apply(e$tri,1,function(tri)rgl::lines3d(e$p[tri,]))
  }
}
}
