% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportionality_index.R
\name{di_prop_index}
\alias{di_prop_index}
\title{Calculate disproportionate impact per the proportionality index (PI) method.}
\usage{
di_prop_index(success, group, cohort, weight, data, di_prop_index_cutoff = 0.8)
}
\arguments{
\item{success}{A vector of success indicators (\code{1}/\code{0} or \code{TRUE}/\code{FALSE}) or an unquoted reference (name) to a column in \code{data} if it is specified.  It could also be a vector of counts, in which case \code{weight} should also be specified (group size).}

\item{group}{A vector of group names of the same length as \code{success} or an unquoted reference (name) to a column in \code{data} if it is specified.}

\item{cohort}{(Optional) A vector of cohort names of the same length as \code{success} or an unquoted reference (name) to a column in \code{data} if it is specified.  disproportionate impact is calculated for every group within each cohort.  When \code{cohort} is not specified, then the analysis assumes a single cohort.}

\item{weight}{(Optional) A vector of case weights of the same length as \code{success} or an unquoted reference (name) to a column in \code{data} if it is specified.  If \code{success} consists of counts instead of success indicators (1/0), then \code{weight} should also be specified to indicate the group size.}

\item{data}{(Optional) A data frame containing the variables of interest.  If \code{data} is specified, then \code{success}, \code{group}, and \code{cohort} will be searched within it.}

\item{di_prop_index_cutoff}{A numeric value between 0 and 1 that is used to determine disproportionate impact if the proportionality index falls below this threshold; defaults to 0.80.}
}
\value{
A data frame consisting of:
\itemize{
  \item \code{cohort} (if used),
  \item \code{group},
  \item \code{n} (sample size),
  \item \code{success} (number of successes for the cohort-group),
  \item \code{pct_success} (proportion of successes attributed to the group within the cohort),
  \item \code{pct_group} (proportion of sample attributed to the group within the cohort),
  \item \code{di_prop_index} (ratio of pct_success to pct_group),
  \item \code{di_indicator} (1 if \code{di_prop_index < di_prop_index_cutoff}), and
  \item \code{success_needed_not_di} (the number of additional successes needed in order to no longer be considered disproportionately impacted as compared to the reference), and
  \item \code{success_needed_full_parity} (the number of additional successes needed in order to achieve full parity with the reference).
}
When \code{di_prop_index < 1}, then there are signs of disproportionate impact.
}
\description{
Calculate disproportionate impact per the proportionality index (PI) method.
}
\details{
This function determines disproportionate impact based on the proportionality index (PI) method, as described in \href{https://www.cccco.edu/-/media/CCCCO-Website/Files/DII/guidelines-for-measuring-disproportionate-impact-in-equity-plans-tfa-ada.pdf}{this} reference from the California Community Colleges Chancellor's Office.  It assumes that a higher rate is good ("success").  For rates that are deemed negative (eg, rate of drop-outs, high is bad), then consider looking at the converse of the non-success (eg, non drop-outs, high is good) instead in order to leverage this function properly.
}
\examples{
library(dplyr)
data(student_equity)
di_prop_index(success=Transfer, group=Ethnicity, data=student_equity) \%>\%
  as.data.frame
}
\references{
California Community Colleges Chancellor's Office (2014).  \href{https://www.cccco.edu/-/media/CCCCO-Website/About-Us/Divisions/Digital-Innovation-and-Infrastructure/Network-Operations/Accountability/Files/GUIDELINES-FOR-MEASURING-DISPROPORTIONATE-IMPACT-IN-EQUITY-PLANS.ashx}{Guidelines for Measuring Disproportionate Impact in Equity Plans}.
}
