% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteFDR-package.R
\docType{package}
\name{DiscreteFDR}
\alias{DiscreteFDR-package}
\alias{DiscreteFDR}
\title{DiscreteFDR}
\description{
This package implements the [HSU], [HSD],
[AHSU], [AHSD] and [HBR-\eqn{\lambda}] procedures for
discrete tests (see References).
}
\details{
The functions are reorganized from the reference paper in the following way.
\link{discrete.BH} (for Discrete Benjamini-Hochberg) implements
[HSU], [HSD], [AHSU] and [AHSD], while \link{DBR} (for Discrete
Blanchard-Roquain) implements [HBR-\eqn{\lambda}]. \link{DBH} and \link{ADBH} are
wrapper functions for \link{discrete.BH} to access [HSU] and [HSD], as well as
[AHSU] and [AHSD] directly. Their main arguments are a vector of raw
observed p-values, and a list of the same length, whose elements are the
discrete supports of the CDFs of the p-values.

The function \link{fisher.pvalues.support} allows to compute such p-values and
support in the framework of a Fisher's exact test of association. It has been
inspired by a help page of the package \code{discreteMTP}, which is no longer
available on CRAN.

The function \link{fast.Discrete} is a wrapper for \link{fisher.pvalues.support} and
\link{discrete.BH} which allows to apply discrete procedures directly to a data
set of contingency tables.

We also provide the \code{amnesia} data set, used in our examples and in our
paper. It is basically the \code{amnesia} data set of package \code{discreteMTP} (no
longer on CRAN), but slightly reformatted such that each line represents a
2x2 contingency table.

No other function of the package should be used directly, as they are only
internal functions called by the main ones.
}
\references{
Döhler, S., Durand, G., & Roquain, E. (2018). New FDR bounds for discrete
and heterogeneous tests. \emph{Electronic Journal of Statistics}, \emph{12}(1),
pp. 1867-1900. \doi{10.1214/18-EJS1441}

G. Blanchard and E. Roquain (2009). Adaptive false discovery rate control
under independence and dependence. \emph{Journal of Machine Learning Research},
\emph{10}, pp. 2837-2871.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DISOhda/DiscreteFDR}
  \item Report bugs at \url{https://github.com/DISOhda/DiscreteFDR/issues}
}

}
\author{
\strong{Maintainer}: Darmstadt Institute of Statistics and Operations Research \email{diso.fbmn@h-da.de}

Authors:
\itemize{
  \item Sebastian Döhler [contributor]
  \item Florian Junge [contributor]
  \item Guillermo Durand [contributor]
}

Other contributors:
\itemize{
  \item Etienne Roquain [contributor]
  \item Christina Kihn [contributor]
}

}
