% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_beta.R
\name{Etronq_beta}
\alias{Etronq_beta}
\title{Truncated mean of the Beta distribution}
\usage{
Etronq_beta(d, shape1, shape2, less.than.d = TRUE)
}
\arguments{
\item{d}{cut-off value. Recall the the domain is limited between 0 and 1.}

\item{shape1}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{shape2}{shape parameter \eqn{\beta}{beta}, must be positive.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_beta}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_beta}}}{ gives the expected value.}
 \item{\code{\link{V_beta}}}{ gives the variance.}
 \item{\code{\link{kthmoment_beta}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_beta}}}{ gives the truncated mean.}
 \item{\code{\link{SL_beta}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_beta}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_beta}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_beta}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Beta distribution with shape parameters
 \eqn{\alpha}{alpha} and \eqn{\beta}{beta}.
}
\details{
The Beta distribution with shape parameters \eqn{\alpha}{a} and
  \eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\Gamma(\alpha + \beta)}{\Gamma(\alpha) %
   \Gamma(\beta)} x^{\alpha - 1} (1 - x)^(\beta - 1)}{f(x) = Γ(a+b) / %
   (Γ(a)Γ(b))x^(a - 1)(1 - x)^(b - 1)}
  for \eqn{x \in [0, 1]}{0 ≤ x ≤ 1}, \eqn{\alpha, \beta > 0}{a, b > 0}.
}
\examples{

Etronq_beta(d = 0.4, shape1 = 4, shape2 = 5)
Etronq_beta(d = 0.4, shape1 = 4, shape2 = 5, less.than.d = FALSE)

}
\seealso{
Other Beta Distribution: 
\code{\link{E_beta}()},
\code{\link{Elim_beta}()},
\code{\link{MGF_beta}()},
\code{\link{Mexcess_beta}()},
\code{\link{SL_beta}()},
\code{\link{TVaR_beta}()},
\code{\link{V_beta}()},
\code{\link{VaR_beta}()},
\code{\link{kthmoment_beta}()}
}
\concept{Beta Distribution}
