% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_pois.R
\name{Etronq_pois}
\alias{Etronq_pois}
\title{Truncated mean of the Poisson distribution}
\usage{
Etronq_pois(d, lambda, k0, less.than.d = TRUE)
}
\arguments{
\item{d}{cut-off value.}

\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}

\item{k0}{point up to which to sum the distribution to approximate the expected value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_pois}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{PGF_pois}}}{ gives the probability generating function (PGF).}
 \item{\code{\link{E_pois}}}{ gives the expected value.}
 \item{\code{\link{V_beta}}}{ gives the variance.}
 \item{\code{\link{Etronq_pois}}}{ gives the truncated mean.}
 \item{\code{\link{TVaR_pois}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Poisson distribution with rate parameter
 \eqn{\lambda}{lambda}.
}
\details{
The Poisson distribution with rate parameter \eqn{\lambda}{lam}
  has probability mass function :
  \deqn{Pr(X = k) = \frac{\lambda^k \textrm{e}^{-\lambda}}{k!}}{Pr(X = k) = (lam^k e^(-lam)) / k!}
  for \eqn{k = 0, 1, 2, \dots}{k = 0, 1, 2, ...}, and \eqn{\lambda > 0}{lam > 0}
}
\examples{

Etronq_pois(d = 0, lambda = 2, k0 = 2E2, less.than.d = FALSE)
Etronq_pois(d = 2, lambda = 2, k0 = 2E2, less.than.d = TRUE)

}
\seealso{
Other Poisson Distribution: 
\code{\link{E_pois}()},
\code{\link{MGF_pois}()},
\code{\link{PGF_pois}()},
\code{\link{TVaR_pois}()},
\code{\link{V_pois}()}
}
\concept{Poisson Distribution}
