% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{Pareto}
\alias{Pareto}
\alias{dPareto}
\alias{pPareto}
\alias{expValPareto}
\alias{varPareto}
\alias{kthMomentPareto}
\alias{expValLimPareto}
\alias{expValTruncPareto}
\alias{stopLossPareto}
\alias{meanExcessPareto}
\alias{VatRPareto}
\alias{TVatRPareto}
\title{Pareto Distribution}
\usage{
dPareto(x, shape, rate = 1/scale, scale = 1/rate)

pPareto(q, shape, rate = 1/scale, scale = 1/rate, lower.tail = TRUE)

expValPareto(shape, rate = 1/scale, scale = 1/rate)

varPareto(shape, rate = 1/scale, scale = 1/rate)

kthMomentPareto(k, shape, rate = 1/scale, scale = 1/rate)

expValLimPareto(d, shape, rate = 1/scale, scale = 1/rate)

expValTruncPareto(d, shape, rate = 1/scale, scale = 1/rate, less.than.d = TRUE)

stopLossPareto(d, shape, rate = 1/scale, scale = 1/rate)

meanExcessPareto(d, shape, rate = 1/scale, scale = 1/rate)

VatRPareto(kap, shape, rate = 1/scale, scale = 1/rate)

TVatRPareto(kap, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{x}{vector of quantiles.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{rate}{rate parameter \eqn{\lambda}{lambda}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{dPareto}}}{ gives the probability density function (PDF).}
    \item{\code{\link{pPareto}}}{ gives the cumulative density function (CDF).}
    \item{\code{\link{expValPareto}}}{ gives the expected value.}
    \item{\code{\link{varPareto}}}{ gives the variance.}
    \item{\code{\link{kthMomentPareto}}}{ gives the kth moment.}
    \item{\code{\link{expValLimPareto}}}{ gives the limited mean.}
    \item{\code{\link{expValTruncPareto}}}{ gives the truncated mean.}
    \item{\code{\link{stopLossPareto}}}{ gives the stop-loss.}
    \item{\code{\link{meanExcessPareto}}}{ gives the mean excess loss.}
    \item{\code{\link{VatRPareto}}}{ gives the Value-at-Risk.}
    \item{\code{\link{TVatRPareto}}}{ gives the Tail Value-at-Risk.}
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Pareto distribution with shape parameter \eqn{\alpha}{alpha} and rate
parameter \eqn{\lambda}{lambda}.
}
\details{
The Pareto distribution with rate parameter \eqn{\lambda}{lam} as well as shape
parameter \eqn{\alpha}{a} has density:
  \deqn{f\left(x\right) = \frac{\alpha\lambda^{\alpha}}%
  {(\lambda + x)^{\alpha + 1}}}{f(x) = (a lam^a)/ (lam + x)^(a + 1)}
for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\alpha, \lambda > 0}{a, lam > 0}.
}
\examples{
# With scale parameter
dPareto(x = 2, shape = 2, scale = 5)

# With rate parameter
dPareto(x = 2, shape = 2, rate = .20)

# With scale parameter
pPareto(q = 2, shape = 2, scale = 5)

# With rate parameter
pPareto(q = 2, shape = 2, rate = 0.20)

# Survival function
pPareto(q = 2, shape = 2, rate = 0.20, lower.tail = FALSE)

# With scale parameter
expValPareto(shape = 5, scale = 0.5)

# With rate parameter
expValPareto(shape = 5, rate = 2)

# With scale parameter
varPareto(shape = 5, scale = 0.5)

# With rate parameter
varPareto(shape = 5, rate = 2)

# With scale parameter
kthMomentPareto(k = 4, shape = 5, scale = 0.5)

# With rate parameter
kthMomentPareto(k = 4, shape = 5, rate = 2)

# With scale parameter
expValLimPareto(d = 4, shape = 5, scale = 0.5)

# With rate parameter
expValLimPareto(d = 4, shape = 5, rate = 2)

# With scale parameter
expValTruncPareto(d = 4, shape = 5, scale = 0.5)

# With rate parameter
expValTruncPareto(d = 4, shape = 5, rate = 2)

# With scale parameter
stopLossPareto(d = 2, shape = 5, scale = 0.5)

# With rate parameter
stopLossPareto(d = 2, shape = 5, rate = 2)

# With scale parameter
meanExcessPareto(d = 6, shape = 5, scale = 0.5)

# With rate parameter
meanExcessPareto(d = 6, shape = 5, rate = 2)

# With scale parameter
VatRPareto(kap = .99, shape = 5, scale = 0.5)

# With rate parameter
VatRPareto(kap = .99, shape = 5, rate = 2)

# With scale parameter
TVatRPareto(kap = .99, shape = 5, scale = 0.5)

# With rate parameter
TVatRPareto(kap = .99, shape = 5, rate = 2)

}
