% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifDiscr.R
\name{unifDiscr}
\alias{unifDiscr}
\alias{pUnifD}
\alias{dUnifD}
\alias{varUnifD}
\alias{expValUnifD}
\title{Discrete Uniform Distribution}
\usage{
pUnifD(q, min = 0, max = 1)

dUnifD(x, min = 0, max = 1)

varUnifD(min = 0, max = 1)

expValUnifD(min = 0, max = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{min}{lower and upper limits of the distribution.  Must be finite.}

\item{max}{lower and upper limits of the distribution.  Must be finite.}

\item{x}{vector of quantiles.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{dUnifD}}}{ gives the probability density function (PDF).}
    \item{\code{\link{pUnifD}}}{ gives the cumulative density function (CDF).}
    \item{\code{\link{expValUnifD}}}{ gives the expected value.}
    \item{\code{\link{varUnifD}}}{ gives the variance.}
  }
Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Discrete uniform distribution with min \eqn{a} and max \eqn{b}.
}
\details{
The (discrete) uniform distribution with min and max parameters \eqn{a}
and \eqn{b} respectively has density:
  \deqn{\textrm{Pr}\left(X = x \right) = \frac{1}{b - a + 1}}{Pr(X = x) = 1 / (b - a + 1)}
for \eqn{x \in \{a, a + 1, \dots, b - 1, b\}}{x = a, a + 1, ..., b - 1, b}.
}
\examples{
pUnifD(q = 0.2, min = 0, max = 1)

dUnifD(min = 0, max = 1)

varUnifD(min = 0, max = 1)

expValUnifD(min = 0, max = 1)

}
