% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{occupancy.predict}
\alias{occupancy.predict}
\title{Predicts occupancy for all the species in a batchoccupancy class object}
\usage{
occupancy.predict(batch, new.data)
}
\arguments{
\item{batch}{A result from the batchoccu}

\item{new.data}{a rasterstack, or a dataframe containing the same variables as
the siteCovs variable in batchoccu}
}
\value{
a raster stack with predictions
for each species.
}
\description{
This function takes an batchoccupancy object and predicts occupancy for all species
in new data, either a data.frame or a rasterstack.
}
\examples{
\dontrun{
#Load the data
data("BatOccu")
data("Dailycov")
data("sampling.cov")
data("plumas.stack")

#Model the abundance for 17 bat species and calculate alpha diversity from that

BatOccupancy <-batchoccu(pres = BatOccu, sitecov = sampling.cov,
obscov = Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~ Burn.intensity.soil + I(Burn.intensity.soil^2) +
Burn.intensity.Canopy + I(Burn.intensity.Canopy^2) + Burn.intensity.basal +
I(Burn.intensity.basal^2))

Occupancy.stack <- occupancy.predict(batch = BatOccupancy, new.data =
plumas.stack)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}

