% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCTtest.R
\name{MCTpval}
\alias{MCTpval}
\title{Calculate multiplicity adjusted p-values for multiple contrast test}
\usage{
MCTpval(
  contMat,
  corMat,
  df,
  tStat,
  alternative = c("one.sided", "two.sided"),
  control = mvtnorm.control()
)
}
\arguments{
\item{contMat}{Contrast matrix to use. The individual contrasts should be saved in the columns of the matrix}

\item{corMat}{Correlation matrix of contrasts}

\item{df}{Degrees of freedom to use for calculation.}

\item{tStat}{Vector of contrast test statistics}

\item{alternative}{Character determining the alternative for the multiple contrast trend test.}

\item{control}{A list specifying additional control parameters for the \samp{qmvt} and \samp{pmvt} calls in the code,
see also \code{\link{mvtnorm.control}} for details.}
}
\value{
Numeric containing the calculated p-values.
}
\description{
Calculate multiplicity adjusted p-values for a maximum contrast test corresponding to a set of contrasts and given a
set of observed test statistics. This function is exported as it may be a useful building block and used in more
complex testing situations that are not covered by \code{\link{MCTtest}}. Most users probably don't need to use this
function.
}
\examples{
data(biom)
## define shapes for which to calculate optimal contrasts
modlist <- Mods(emax = 0.05, linear = NULL, logistic = c(0.5, 0.1),
                linInt = c(0, 1, 1, 1), doses = c(0, 0.05, 0.2, 0.6, 1))
contMat <- optContr(modlist, w=1)$contMat
## calculate inputs needed for MCTpval
fit <- lm(resp~factor(dose)-1, data=biom)
est <- coef(fit)
vc <- vcov(fit)
ct <- as.vector(est \%*\% contMat)
covMat <- t(contMat) \%*\% vc \%*\% contMat
den <- sqrt(diag(covMat))
tStat <- ct/den
corMat <- cov2cor(t(contMat) \%*\% vc \%*\% contMat)
MCTpval(contMat, corMat, df=100-5, tStat)
## compare to
test <- MCTtest(dose, resp, biom, models=modlist)
attr(test$tStat, "pVal")
}
\references{
Pinheiro, J. C., Bornkamp, B., and Bretz, F. (2006). Design and analysis of dose finding studies
  combining multiple comparisons and modeling procedures, \emph{Journal of Biopharmaceutical Statistics}, \bold{16},
  639--656
}
\seealso{
\code{\link{MCTtest}}, \code{\link{optContr}}
}
\author{
Bjoern Bornkamp
}
