% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalSpectralRiskMeasure.R
\name{NormalSpectralRiskMeasure}
\alias{NormalSpectralRiskMeasure}
\title{Estimates the spectral risk measure of a portfolio}
\usage{
NormalSpectralRiskMeasure(mu, sigma, gamma, number.of.slices)
}
\arguments{
\item{mu}{Mean losses}

\item{sigma}{Standard deviation of losses}

\item{gamma}{Gamma parameter in exponential risk aversion}

\item{number.of.slices}{Number of slices into which density function is divided}
}
\value{
Estimated spectral risk measure
}
\description{
Function estimates the spectral risk measure of a portfolio
assuming losses are normally distributed, assuming exponential weighting
function with specified gamma.
}
\examples{
# Generates 95\% confidence intervals for normal VaR for given parameters
   NormalSpectralRiskMeasure(0, .5, .8, 20)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

