% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tESPlot3D.R
\name{tESPlot3D}
\alias{tESPlot3D}
\title{Plots t ES against confidence level and holding period}
\usage{
tESPlot3D(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily P/L data

 mu Mean of daily P/L data

 sigma Standard deviation of daily P/L data

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a vector}
}
\description{
Plots the ES of a portfolio against confidence level and holding period
assuming that P/L are Student-t distributed, for specified confidence level
and holding period.
}
\examples{
# Plots ES against confidene level given P/L data
   data <- runif(5, min = 0, max = .2)
   tESPlot3D(returns = data, df = 6, cl = seq(.85,.99,.01), hp = 60:90)

   # Computes ES against confidence level given mean and standard deviation of return data
   tESPlot3D(mu = .012, sigma = .03, df = 6, cl = seq(.85,.99,.02), hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

