% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{drug_target_edges_example}
\alias{drug_target_edges_example}
\title{Drug target nodes in combined network}
\format{
A named list with 2 items.
\describe{
  \item{targets}{A named list}
  \describe{
  \item{target_nodes}{data frame with column `node_id` (unique node IDs in the graph targeted by
   drugs) and columns `groupA` and `groupB` (bool values specifying whether the node is
   contained in the combined graph of the group)}
  \item{drugs_to_target_nodes}{Element `drugs_to_target_nodes` contains a named list mapping drug
   names to a vector of their target node IDs.}
  }
  \item{edgelists}{Contains elements `groupA` and `groupB` containing each a data frame of edges
  adjacent to drug target nodes each. Each edgelist data frame contains columns `from`, `to` and
  `weight`.}
}
}
\source{
The Drug Gene Interaction Database: \url{https://www.dgidb.org/}
}
\usage{
drug_target_edges_example
}
\description{
Exemplary intermediate pipeline output: Drug targets detected in the combined
graphs. A named list with elements `targets` and `edgelists`. This was created with
\code{\link[DrDimont]{determine_drug_targets}} using the \link[DrDimont]{combined_graphs_example}
 and:
}
\details{
\code{drug_target_interactions <- make_drug_target(target_molecules='protein',
             interaction_table=drug_gene_interactions,
             match_on='gene_name')}

Drug-gene interactions to calculate this output were used from
The Drug Gene Interaction Database.
}
\keyword{datasets}
