% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{DurgaTransparent}
\alias{DurgaTransparent}
\title{Returns a transparent version of the specified colour(s).}
\usage{
DurgaTransparent(colour, transparency, relative = FALSE)
}
\arguments{
\item{colour}{The R colour (or colours) to be made transparent. May be
specified in any way recognised by \code{\link[grDevices]{col2rgb}}: a
colour name, a hexadecimal string such as \code{"#ffbc48"} or a positive
integer \code{i} meaning meaning \code{\link[grDevices]{palette}()[i]}.}

\item{transparency}{Transparency, from \code{0}, meaning fully opaque, through to
\code{1}, which is completely transparent (i.e. invisible).}

\item{relative}{Determines what happens if \code{colour} is already
transparent. If \code{relative} is \code{FALSE} (the default), then the
transparency value of \code{colour} is ignored and \code{transparency} defines the
transparency of the returned colour. If \code{TRUE}, the existing
transparency value is multiplied by \code{transparency}.}
}
\value{
A colour or colours that are transparent versions of \code{colour}.
}
\description{
Returns a transparent version of the specified colour(s).
}
\examples{
transparentPink <- DurgaTransparent("red", 0.8)
transparentPink

}
\seealso{
\code{\link[grDevices]{col2rgb}}, \code{\link[grDevices]{rgb}}
}
