% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DyMEP_pheno_phase_prediction.R
\name{pheno_phase_prediction}
\alias{pheno_phase_prediction}
\title{function to predict the a phenological phase in winter wheat}
\usage{
pheno_phase_prediction(
  phase_covariate_list,
  environmental_data,
  phase_starting_date,
  crop_abbrev,
  output_type = "dates",
  external_params_path = NULL
)
}
\arguments{
\item{phase_covariate_list}{list like: list("sowing-emergence" =
c("tas","VPD","SPI"),
"emergence-jointing" = c("tas"))
indicating per phenological phase the covariates to use. List of
of phenological phases must be consecutive!}

\item{environmental_data}{data.frame with the necessary environmental data,
one column must be "DATE" (as.Date format), the others with the names of
the environmental covariates (e.g. tas, tasmin etc.)}

\item{phase_starting_date}{starting date of the first phase which will be
predicted (object of class "Date" (use as.Date()))}

\item{crop_abbrev}{abbreviation of the crop to be modeled (valid crop_abbrevs
can be found with available_crops_and_phases())}

\item{output_type}{either "dates" or "detailed_information"; defines what
output of the model they user wants to have as return,
default is set to "dates". If a user wants to get the response parameters,
curves, predictions and model thresholds, it should be chosen
"detailed_information"
output = "dates" will return a dataframe with the stages and according dates
output = "detailed_information" will return a list with the dates, but also
 the corresponding dose response parameters and predictions}

\item{external_params_path}{path where additional crop parameters should be
stored if not possible to download in to the regular R repository. The
default is NULL, which will use the regular R repository as path}
}
\value{
returns the end-date of each phase

either return an object of class 'DyMEP', if detailed_information is
 selected as output_type, from a dataframe containing phenology data, or
}
\description{
predict one or all phenological phases
}
\examples{
pheno_phase_prediction(phase_covariate_list = list(
        "sowing-emergence" = c("tasmin","VPD","SPI","tasmax","tas","RH",
        "global_radiation"),
        "emergence-jointing"= c("tasmin","VPD","SPI","tasmax","tas","RH",
        "global_radiation"),
        "jointing-heading" = c("tasmin","VPD","SPI","tasmax","tas","RH",
        "global_radiation")),
    environmental_data <- data.frame("DATE" = seq.Date(
              from = as.Date("2021-01-01"), to = as.Date("2023-12-31"),by=1),
                          "tas"=runif(1095,min=-10,max=40),
                           "RH"=runif(1095,min=0,max=100),
                           "tasmin"=runif(1095,min=-10,max=40),
                           "tasmax"=runif(1095,min=-5,max=40),
                           "VPD" = runif(1095,min=0,max=40),
                           "SPI"= runif(1095,min=-1,max=4),
                           "global_radiation"= runif(1095,min=0,max=10000)),
      phase_starting_date =as.Date("2021-01-01"),
      crop_abbrev = "WW")
}
\keyword{phase}
\keyword{phenology}
\keyword{prediction}
