% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OOB_rfshape.R
\name{OOB.rfshape}
\alias{OOB.rfshape}
\title{Compute the Out-Of-Bag error on the random survival forest}
\usage{
OOB.rfshape(
  rf,
  Longitudinal = NULL,
  Numeric = NULL,
  Factor = NULL,
  Y,
  IBS.min = 0,
  IBS.max = NULL,
  cause = 1,
  ncores = NULL
)
}
\arguments{
\item{rf}{Trees object resulting from \code{rf_shape_para} function}

\item{Longitudinal}{A list of longitudinal predictors which should contain: \code{X} a dataframe with one row for repeated measurement and as many columns as markers; \code{id} is the vector of the identifiers for the repeated measurements contained in \code{X}; \code{time} is the vector of the measurement times contained in \code{X}.}

\item{Numeric}{A list of numeric predictors which should contain: \code{X} a dataframe with as many columns as numeric predictors; \code{id} is the vector of the identifiers for each individual.}

\item{Factor}{A list of factor predictors which should contain: \code{X} a dataframe with as many columns as factor predictors; \code{id} is the vector of the identifiers for each individual.}

\item{Y}{A list of output which should contain: \code{type} defines the nature of the output, can be "\code{surv}", "\code{numeric}" or "\code{factor}"; \code{Y} is the output variable; \code{id} is the vector of the identifiers for each individuals, they should be the same as the identifiers of the Inputs.}

\item{IBS.min}{(Only with survival outcome) Minimal time to compute the Integrated Brier Score. Default value is set to 0.}

\item{IBS.max}{(Only with survival outcome) Maximal time to compute the Integrated Brier Score. Default value is set to the maximal time-to-event found.}

\item{cause}{(Only with competing events) Number indicates the event of interest.}

\item{ncores}{Number of cores used to grow trees in parallel. Default value is the number of cores of the computer-1.}
}
\description{
Compute the Out-Of-Bag error on the random survival forest
}
\keyword{internal}
