% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_VIMP.R
\name{compute_VIMP}
\alias{compute_VIMP}
\title{Compute the importance of variables (VIMP) statistic}
\usage{
compute_VIMP(
  DynForest_obj,
  IBS.min = 0,
  IBS.max = NULL,
  ncores = NULL,
  seed = round(runif(1, 0, 10000))
)
}
\arguments{
\item{DynForest_obj}{\code{DynForest} object containing the dynamic random forest used on train data}

\item{IBS.min}{(Only with survival outcome) Minimal time to compute the Integrated Brier Score. Default value is set to 0.}

\item{IBS.max}{(Only with survival outcome) Maximal time to compute the Integrated Brier Score. Default value is set to the maximal time-to-event found.}

\item{ncores}{Number of cores used to grow trees in parallel. Default value is the number of cores of the computer-1.}

\item{seed}{Seed to replicate results}
}
\value{
\code{compute_VIMP()} function returns a list with the following elements:\tabular{ll}{
\code{Inputs} \tab A list of 3 elements: \code{Longitudinal}, \code{Numeric} and \code{Factor}. Each element contains the names of the predictors \cr
\tab \cr
\code{Importance} \tab A list of 3 elements: \code{Longitudinal}, \code{Numeric} and \code{Factor}. Each element contains a numeric vector of VIMP statistic predictor in \code{Inputs} value \cr
\tab \cr
\code{tree_oob_err} \tab A numeric vector containing the OOB error for each tree needed to compute the VIMP statistic \cr
\tab \cr
\code{IBS.range} \tab A vector containing the IBS min and max \cr
}
}
\description{
Compute the importance of variables (VIMP) statistic
}
\examples{
\donttest{
data(pbc2)

# Get Gaussian distribution for longitudinal predictors
pbc2$serBilir <- log(pbc2$serBilir)
pbc2$SGOT <- log(pbc2$SGOT)
pbc2$albumin <- log(pbc2$albumin)
pbc2$alkaline <- log(pbc2$alkaline)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run DynForest function
res_dyn <- DynForest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Compute VIMP statistic
res_dyn_VIMP <- compute_VIMP(DynForest_obj = res_dyn, ncores = 2)
}
}
\author{
Anthony Devaux (\email{anthony.devaux@u-bordeaux.fr})
}
