% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_matlab_path.R
\name{add_matlab_path}
\alias{add_matlab_path}
\title{A wrapper for \verb{Octave's} \code{addpath} to add \code{matlab} folder.}
\usage{
add_matlab_path(matlab_path)
}
\arguments{
\item{matlab_path}{Path to the \code{matlab} folder. Default \code{path} is \verb{/usr/lib/dynare/matlab} for \code{Linux}, \verb{/usr/lib/dynare/matlab} for \code{macOS} and \verb{c:/dynare/x.y/matlab} for \code{Windows}, where x.y is \code{Dynare} version number.}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) outputs
}
\description{
Use this function to add \code{matlab} folder.
Use this function if \code{Dynare} is \strong{NOT} installed in the standard location
}
\examples{
library(DynareR)
\dontrun{
add_matlab_path('/usr/lib/dynare/matlab') #  Default for Linux

add_matlab_path('c:/dynare/5.1/matlab') # Default for Windows, but 5.1 can change
# if later version of `Dynare` is installed.

add_matlab_path('/usr/lib/dynare/matlab') # Default for macOS

}
}
\seealso{
Other important functions: 
\code{\link{DynareR}},
\code{\link{add_path}()},
\code{\link{eng_dynare}()},
\code{\link{import_log}()},
\code{\link{include_IRF}()},
\code{\link{input_tex}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\concept{important functions}
\keyword{documentation}
