% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvlasso.R
\name{lassoFit}
\alias{lassoFit}
\title{Compute lasso estimator}
\usage{
lassoFit(X, Y, type, lbd, group = 1:ncol(X), weights = rep(1, max(group)),
  verbose = FALSE, ...)
}
\arguments{
\item{X}{predictor matrix.}

\item{Y}{response vector.}

\item{type}{type of penalty. Must be specified to be one of the following:
\code{"lasso", "grlasso", "slasso"} or \code{"sgrlasso"}, which correspond to
lasso, group lasso, scaled lasso or scaled group lasso.}

\item{lbd}{penalty term of lasso. By letting this argument be \code{"cv.1se"} or
\code{"cv.min"}, users can have the cross-validated lambda that gives either minimum
squared error or that is within 1 std error bound.}

\item{group}{\code{p} x \code{1} vector of consecutive integers describing the group structure.
The number of groups should be the same as max(group). Default is \code{group = 1:p}
, where \code{p} is number of covariates.}

\item{weights}{weight vector with length equal to the number of groups. Default is
\code{weights = rep(1, max(group))}.}

\item{verbose}{logical. Only available for \code{type = "slasso"} or \code{type = "sgrlasso"}.}

\item{...}{auxiliary arguments for \code{lbd = "cv.min", lbd = "cv.1se"}.
See \code{\link{cv.lasso}} for details.}
}
\value{
\item{B0}{coefficient estimator.}

\item{S0}{subgradient.}

\item{sigmaHat}{estimated standard deviation.}

\item{lbd, weights, group}{same as input arguments.}
}
\description{
Computes lasso, group lasso, scaled lasso, or scaled group lasso solution.
The outputs are coefficient-estimate and subgradient. If \code{type = "slasso"}
or \code{type = "sgrlasso"}, the output will include estimated standard deviation.
}
\details{
Computes lasso, group lasso, scaled lasso, or scaled group lasso solution.
Users can specify the value of lbd or choose to run cross-validation to get
optimal lambda in term of mean squared error. Coordinate decent algorithm is used
to fit scaled lasso and sclaed group lasso models.
}
\examples{
set.seed(123)
n <- 50
p <- 10
X <- matrix(rnorm(n*p), n)
Y <- X \%*\% c(1, 1, rep(0, p-2)) + rnorm(n)
#
# lasso
#
lassoFit(X = X, Y = Y, type = "lasso", lbd = .5)
#
# group lasso
#
lassoFit(X = X, Y = Y, type = "grlasso", lbd = .5, weights = rep(1,2),
           group = rep(1:2, each=5))
#
# scaled lasso
#
lassoFit(X = X, Y = Y, type = "slasso", lbd = .5)
#
# scaled group lasso
#
lassoFit(X = X, Y = Y, type = "sgrlasso", lbd = .5, weights = rep(1,2),
           group = rep(1:2, each=5))
}
\references{
Mitra, R. and Zhang, C. H. (2016), "The benefit of group sparsity in group inference with
de-biased scaled group lasso," Electronic Journal of Statistics, 10, 1829-1873.

Yang, Y. and Zou, H. (2015), “A Fast Unified Algorithm for Computing
Group-Lasso Penalized Learning Problems,” Statistics and Computing, 25(6), 1129-1141.
}
