% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHLS.R
\name{summary.MHLS}
\alias{summary.MHLS}
\title{Summarizing Metropolis-Hastings sampler outputs}
\usage{
\method{summary}{MHLS}(object, ...)
}
\arguments{
\item{object}{an object of class "MHLS", which is a result of \code{\link{MHLS}}.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
mean, median, standard deviation, 2.5\% quantile and 97.5\% quantile
for each beta and its subgradient.
}
\description{
Summary method for class "MHLS".
}
\details{
This function provides a summary of each sampled beta and subgradient.
}
\examples{
#' set.seed(123)
n <- 10
p <- 5
X <- matrix(rnorm(n * p), n)
Y <- X \%*\% rep(1, p) + rnorm(n)
sigma2 <- 1
lbd <- .37
weights <- rep(1, p)
LassoResult <- lassoFit(X = X, Y = Y, lbd = lbd, type = "lasso", weights = weights)
B0 <- LassoResult$B0
S0 <- LassoResult$S0
summary(MHLS(X = X, PE = rep(0, p), sig2 = sigma2, lbd = lbd,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     type = "coeff"))
}
