% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotLoading.R
\name{plotLoading}
\alias{plotLoading}
\title{Plot loadings for EEM data}
\usage{
plotLoading(x, ncomp = NULL, ...)
}
\arguments{
\item{x}{output variable from \code{\link[stats]{prcomp}} or \code{\link[pls]{plsr}} functions}

\item{ncomp}{number of components}

\item{...}{(optional) arguments for \code{\link[EEM]{drawEEM}} and \code{\link[graphics]{filled.contour}}}
}
\value{
A figure is returned on the graphic device
}
\description{
Plot loadings for EEM data
}
\examples{
data(applejuice)
applejuice_uf <- unfold(applejuice) # unfold list into matrix
result <- prcomp(applejuice_uf)
plotLoading(result, ncomp = 1) # plot loading of the first PC
}

