% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.FF}
\alias{plot.FF}
\title{Plot Factor Forest (FF) Classification Probability Distribution}
\usage{
\method{plot}{FF}(x, ...)
}
\arguments{
\item{x}{An object of class \code{FF}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates a bar plot of the classification probabilities predicted by the Factor Forest
for determining the number of factors. The plot displays the probability distribution across different numbers of factors,
with each bar representing the probability for a specific number of factors. Unlike the deep neural network (DNN) model,
the Factor Forest can evaluate up to a maximum of 8 factors. The function also annotates each bar with its probability value.
}
\examples{
library(EFAfactors)
set.seed(123)

## Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## Load data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
FF.obj <- FF(response)

## Plot the FF probabilities
plot(FF.obj)
}


}
\seealso{
\link[EFAfactors]{FF}
}
