% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logreg_test.R
\name{logreg_test}
\alias{logreg_test}
\title{Evaluation of \code{ensemble_fs} via logistic
 regression}
\usage{
logreg_test(data, efs_table, file_name, classnumber, NA_threshold)
}
\arguments{
\item{data}{the name of the dataset, which should already be
loaded in the environment.}

\item{efs_table}{table object of class matrix (retrieved
from \code{ensemble_fs})}

\item{file_name}{name of the file, wil be saved as
\code{file_name} + "-ROC.pdf"}

\item{classnumber}{nominal, dichotomous classification.
variable, number of column in dataset, which should be the dependent variable for classification.}

\item{NA_threshold}{(optional) decimal number in range of [0,1]. Threshold for deletion
of features with a greater proportion of NAs than NA_threshold.
than \code{NA_threshold}}
}
\value{
ROC-curve and p-value of \code{\link{roc.test}}
 in a pdf-File
}
\description{
Evaluates the accuracy
 of the ouput of \code{\link{ensemble_fs}} 
 using logistic regression analysis.
 It selects features which have an importance value
 above average and generates a logistic regression
 model. The function compares that model with
 a logistic regression model generated from all
 features (without \code{\link{ensemble_fs}}) and
 shows the results in a ROC-curve. For further
 evaluation the function also shows the p-value
 as result from \code{\link{roc.test}} in the pdf-file.
}
\examples{
 ##loading dataset in Environment
 data(efsdata)
 ##Generate a ranking based on importance (with default
 ##NA_threshold = 0.7,cor_threshold = 0.2)
 efs<-ensemble_fs(efsdata,5,runs=2)
 ##Create a ROC Curve based on the output from ensemble_fs
 logreg_test(efsdata,efs,"test",5)
}
\author{
Ursula Neumann
}
\seealso{
\link[stats]{glm}, \link[pROC]{roc}
}

