% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.redundant.R
\name{node.redundant}
\alias{node.redundant}
\title{Detects Redundant Nodes in a Network}
\usage{
node.redundant(
  data,
  sig,
  type = c("wTO", "pcor", "thresh"),
  method = c("alpha", "bonferroni", "FDR", "adapt")
)
}
\arguments{
\item{data}{Matrix or data frame}

\item{sig}{Numeric.
\emph{p}-value for significance of overlap (defaults to \code{.05}).
If more than 200 connections, then \code{\link[fdrtool]{fdrtool}}
is used to correct for false positives. In these instances, \code{sig}
sets the \emph{q}-value for significance of overlap (defaults to \code{.10})}

\item{type}{Character.
Computes weighted topological overlap (\code{"wTO"} using \code{\link[qgraph]{EBICglasso}}),
partial correlations (\code{"pcor"}), or thresholding
based on a certain level of partial correlations (\code{"thresh"}).
\code{type = "thresh"} will use the argument \code{"sig"} to input
the desired threshold (defaults to \code{sig = .20}).}

\item{method}{Character.
Computes significance using the standard \emph{p}-value (\code{"alpha"}),
bonferroni corrected \emph{p}-value (\code{"bonferroni"}),
false-discovery rate corrected \emph{p}-value (\code{"FDR"}),
or adaptive alpha \emph{p}-value (\code{\link[NetworkToolbox]{adapt.a}}).
Defaults to \code{"alpha"}}
}
\value{
Returns a list:

\item{redundant}{Vectors nested within the list corresponding
to redundant nodes with the name of object in the list}

\item{data}{Returns original data}

\item{weights}{Returns weights determine by weighted topological overlap
or partial correlations}

\item{network}{The network compute by \code{\link[qgraph]{EBICglasso}}}
}
\description{
Identifies redundant nodes in the network based on several
measures. Computes the weighted topological overlap between
each node and every other node in the network. The weighted topological
overlap is implemented using the method from Nowick et al. (2009; see references)
and the function \link[wTO]{wTO} from the wTO package.
}
\examples{
# obtain SAPA items
items <- psychTools::spi[,-c(1:10)]

\donttest{
# weighted topological overlap
redund <- node.redundant(items, type = "wTO", method = "adapt")

# partial correlation
redund <- node.redundant(items, type = "pcor", method = "adapt")
}

}
\references{
#wTO
Nowick, K., Gernat, T., Almaas, E., & Stubbs, L. (2009).
Differences in human and chimpanzee gene expression patterns define an evolving network of transcription factors in brain.
\emph{Proceedings of the National Academy of Sciences}, \emph{106}, 22358-22363.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
