% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyFit.R
\name{entropyFit}
\alias{entropyFit}
\title{Entropy Fit Index}
\usage{
entropyFit(data, structure)
}
\arguments{
\item{data}{Matrix or data frame.
Contains variables to be used in the analysis}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link[EGAnet]{EGA}}}
}
\value{
Returns a list containing:

\item{Total.Correlation}{The total correlation of the dataset}

\item{Total.Correlation.MM}{Miller-Madow correction for the total correlation of the dataset}

\item{Entropy.Fit}{The Entropy Fit Index}

\item{Entropy.Fit.MM}{Miller-Madow correction for the Entropy Fit Index}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a dimensionality structure using empirical entropy.
Lower values suggest better fit of a structure to the data.
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\donttest{# Estimate EGA model
ega.wmt <- EGA(
  data = wmt,
  plot.EGA = FALSE # No plot for CRAN checks
)}

# Compute entropy indices
entropyFit(data = wmt, structure = ega.wmt$wc)

}
\references{
Golino, H., Moulder, R. G., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Nesselroade, J., Sadana, R., Thiyagarajan, J. A., & Boker, S. M. (2020).
Entropy fit indices: New fit measures for assessing the structure and dimensionality of multiple latent variables.
\emph{Multivariate Behavioral Research}.
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and \code{\link[EGAnet]{CFA}} to
verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>, Alexander P. Christensen <alexpaulchristensen@gmail.com> and Robert Moulder <rgm4fd@virginia.edu>
}
