% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{ciBands}
\alias{ciBands}
\title{ciBands}
\usage{
ciBands(eList, repAnnualResults, probs = c(0.05, 0.95))
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{repAnnualResults}{named list returned from bootstrapping process}

\item{probs}{vector high and low confidence interval percentages}
}
\description{
Computes confidence intervals for Flow-Normalized Concentration 
and Flow-Normalized Flux for a WRTDS model.
}
\examples{
library(EGRET)
eList <- Choptank_eList
nBoot <- 100
blockLength <- 200
\dontrun{

repAnnualResults <- vector(mode = "list", length = nBoot)
for(n in 1:nBoot){
   annualResults <- bootAnnual(eList, blockLength) 
   repAnnualResults[[n]] <- bootAnnual(eList, blockLength)
}

CIAnnualResults <- ciBands(eList, repAnnualResults)

}
}

