% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{credible.emc}
\alias{credible.emc}
\alias{credible}
\title{Posterior credible interval tests}
\usage{
\method{credible}{emc}(
  x,
  x_name = NULL,
  x_fun = NULL,
  x_fun_name = "fun",
  selection = "mu",
  y = NULL,
  y_name = NULL,
  y_fun = NULL,
  y_fun_name = "fun",
  x_subject = NULL,
  y_subject = NULL,
  mu = 0,
  alternative = c("less", "greater")[1],
  probs = c(0.025, 0.5, 0.975),
  digits = 2,
  p_digits = 3,
  print_table = TRUE,
  ...
)

credible(x, ...)
}
\arguments{
\item{x}{An emc object}

\item{x_name}{A character string. Name of the parameter to be tested for \code{x}}

\item{x_fun}{Function applied to the MCMC chains to create
variable to be tested.}

\item{x_fun_name}{Name to give to quantity calculated by \code{x_fun}}

\item{selection}{A character string designating parameter type (e.g. \code{alpha} or \code{covariance})}

\item{y}{A second emc object}

\item{y_name}{A character string. Name of the parameter to be tested for \code{y}}

\item{y_fun}{Function applied to the MCMC chains to create
variable to be tested.}

\item{y_fun_name}{Name to give to quantity calculated by \code{y_fun}}

\item{x_subject}{Integer or name selecting a subject}

\item{y_subject}{Integer or name selecting a subject}

\item{mu}{Numeric. \code{NULL} value for single sample test if \code{y} is not supplied (default 0)}

\item{alternative}{\code{less} or \code{greater} determining direction of test probability}

\item{probs}{Vector defining quantiles to return.}

\item{digits}{Integer, significant digits for estimates in printed results}

\item{p_digits}{Integer, significant digits for probability in printed results}

\item{print_table}{Boolean (defaults to \code{TRUE}) for printing results table}

\item{...}{Additional optional arguments that can be passed to \code{get_pars}}
}
\value{
Invisible results table with no rounding.
}
\description{
Modeled after \code{t.test}, returns the credible interval of the parameter or test
and what proportion of the posterior distribution (or the difference in posterior distributions
in case of a two sample test) overlaps with mu.
For a one sample test provide \code{x} and for two sample also provide \code{y}.
Note that for comparisons within one model, we recommend using \code{hypothesis()} if the priors
were well chosen.
}
\examples{
\dontrun{
# Run a credible interval test (Bayesian ''t-test'')
# Here the full model is an emc object with the hypothesized effect
design_full <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))

full_model <- make_emc(forstmann, design_full)
full_model <- fit(full_model)
credible(full_model, x_name = "v")
# We can also compare between two sets of emc objects
# Now without a ~ E
design_null <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~1, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))

null_model <- make_emc(forstmann, design_null)
null_model <- fit(null_model)
credible(x = null_model, x_name = "a", y = full_model, y_name = "a")

# Or provide custom functions
credible(x = full_model, x_fun = function(d) d["a_Eaccuracy"] - d["a_Eneutral"])
}
}
