% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApproxF.R
\name{ApproxF}
\alias{ApproxF}
\title{Calculate ANOVA with approximate F value}
\usage{
ApproxF(SS.table,approx.name)
}
\arguments{
\item{SS.table}{result from EMSanova}

\item{approx.name}{rowname in SS.table to calculate approximate F value for the test.}
}
\description{
Calculate ANOVA with approximate F value
}
\examples{
data(film)
anova.result<-EMSanova(thickness~Gate*Operator*Day,data=film,
                        type=c("F","R","R"))
anova.result                         
ApproxF(SS.table=anova.result,approx.name="Gate") 
EMSanova(thickness~Gate+Operator+Day,data=film,
          type=c("F","R","R"),
          approximate=TRUE)                      
       
}

