% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{binClst-class}
\alias{binClst-class}
\title{Binary Clustering Class}
\description{
\code{binClst} is a generic multivariate binary clustering object.
}
\section{Slots}{

\describe{
\item{\code{X}}{The input data set. A multivariate matrix where each row is a data point and each column is an input feature (a variable).}

\item{\code{U}}{A multivariate matrix with same dimension as X with the values of certainty associated to each corresponding value in X. Ceartainties assign reliability to the data points so that the less reliable is a data point the less its leverage in the clustering. By default certainties are set to one for all variables of all data points.}

\item{\code{stdv}}{A numeric vector with variable specific values for minimum standard deviation.}

\item{\code{m}}{The number of input features.}

\item{\code{k}}{The number of clusters.}

\item{\code{n}}{The number of observations (data points).}

\item{\code{R}}{A matrix with the values delimiting each binary region (the \code{Reference} values).}

\item{\code{P}}{A list with the GMM (Gaussian Mixture Model) parameters. Each element of the list corresponds to a component of the GMM and it is a named-sublist itself, with elements '$M' (the component's mean) and '$S' (the component's covariance matrix).}

\item{\code{W}}{A n*k matrix with the likelihood weights.}

\item{\code{A}}{A numeric vector with the clustering labels (annotations) for each data-point (the basic output data). Labels are assigned based on the likelihood weights. Only in case of equal likelihoods the delimiters are used as a further criterion to assign labels.}

\item{\code{L}}{The values of likelihood at each step of the optimization process.}

\item{\code{C}}{Default color palette used for the plots. Can be changed by means of the setc() function.}
}}

