\name{eval.plot }
\alias{eval.plot}
\title{ Generate Basic Plot for ENMevaluate Output }
\description{ This function can be used to generate a basic plot of evaluation metrics generated by a call of \code{\link{ENMevaluate}}.
	 }
\usage{
eval.plot(results, value = "delta.AICc", variance = NULL, legend = TRUE, 
	legend.position = "topright")
}
\arguments{
  \item{results}{ A data.frame of results from \code{\link{ENMevaluate}}. }
  \item{value}{ Character string of the column of \code{results} to use for plotting.}
  \item{variance}{ Character string of the column of \code{results} to be used for error bars. }
  \item{legend}{ logical; If \code{TRUE} (default), includes legend in plot with \code{fc}s.}
  \item{legend.position}{ Character string for the placement of the legend.}
}
\author{ Robert Muscarella <bob.muscarella@gmail.com> }
\examples{

data(enmeval_results)

par(mfrow=c(2,2))
eval.plot(enmeval_results@results, legend.position="topright")
eval.plot(enmeval_results@results, "Mean.AUC", )
eval.plot(enmeval_results@results, "Mean.AUC.DIFF", variance="Var.AUC.DIFF")
eval.plot(enmeval_results@results, "Mean.ORmin")

}
