\name{var.importance}

\alias{var.importance}

\title{
Extract percent contribution and permutation importance from a Maxent model
}

\description{ Extract the percent contribution and permutation importance metrics generated by a Maxent model. }

\usage{
var.importance(mod)
}

\arguments{
\item{mod}{ A Maxent model object.}}

\details{Maxent provides two metrics to determine the importance of input variables in the final model: \bold{percent contribution} and \bold{permutation importance}. This function extracts both metrics from the results slot of a maxent model object and places them into a \code{data.frame}.

\emph{According to Phillips (2006), the \bold{percent contribution} of each variable is calculated as follows:}

"While the Maxent model is being trained, it keeps track of which environmental variables are contributing to fitting the model.  Each step of the Maxent algorithm increases the gain of the model by modifying the coefficient for a single feature; the program assigns the increase in the gain to the environmental variable(s) that the feature depends on.  Converting to percentages at the end of the training process, we get the percent contribution."

"The percent contribution values are only heuristically defined: they depend on the particular path that the Maxent code uses to get to the optimal solution, and a different algorithm could get to the same solution via a different path, resulting in different percent contribution values.  In addition, when there are highly correlated environmental variables, the percent contributions should be interpreted with caution."

\emph{Also according to Phillips (2006), the \bold{permutation importance} of each variable is calculated as follows:}

"...for each environmental variable in turn, the values of that variable on training presence and background data are randomly permuted. The model is reevaluated on the permuted data, and the resulting drop in training AUC is shown in the table, normalized to percentages."

"The permutation importance measure depends only on the final Maxent model, not the path used to obtain it.  The contribution for each variable is determined by randomly permuting the values of that variable among the training points (both presence and background) and measuring the resulting decrease in training AUC.  A large decrease indicates that the model depends heavily on that variable.  Values are normalized to give percentages."}

\value{A \code{data.frame} with the percent contribution and permutation importance for each variable included in a Maxent model.}

\note{Both metrics should be interpreted with caution when the predictor variables are correlated (Phillips 2006).}

\references{Phillips, S. (2006) A brief tutorial on Maxent. AT&T Research. Available at: http://www.cs.princeton.edu/~schapire/maxent/tutorial/tutorial.doc}

\author{Jamie M. Kass <jkass@gc.cuny.edu> and Robert Muscarella <bob.muscarella@gmail.com>}

\examples{
data(enmeval_results)

# Select model with lowest AICc

aic.mod <- enmeval_results@models[[which(enmeval_results@results$delta.AICc==0)]]
var.importance(aic.mod)

# See the variable importance metrics for the first 3 models

lapply(enmeval_results@models, var.importance)[1:3]
}
