% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEPX.R
\name{predict.epx}
\alias{predict.epx}
\title{Predict with an "\code{epx}" object}
\usage{
\method{predict}{epx}(object, newdata, classifier.args = list(), ...)
}
\arguments{
\item{object}{Object of class "\code{\link{epx}}".}

\item{newdata}{An optional data frame specifiying variables with which to
predict; if omitted and \code{classifier.args} are not specified, the
fitted (ensembled) values are used.}

\item{classifier.args}{Additional arguments for the base classifier; same
base classifier as that used for phalanx-formation (specified in
\code{\link{epx}}).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Numeric vector of predicted values (double).
}
\description{
Predicted values based on an "\code{\link{epx}}" object; may specify
different base classifier arguments than those used for phalanx-formation.
}
\examples{
# Example with data(harvest)

## Phalanx-formation using a base classifier with 50 trees (default = 500)
\donttest{
set.seed(761)
model <- epx(x = harvest[, -4], y = harvest[, 4],
             classifier.args = list(ntree = 50))

## Predict training values without additional classifier.args and newdata
## returns the object's ENSEMBLED.FITS
all.equal(predict(model), model$ENSEMBLED.FITS)

## Predict training values using 100 trees (default = 500)
set.seed(761)
preds100 <- predict(model, classifier.args = list(ntree = 100))

## Predict test values by passing dataframe of test predictors to newdata as
## with the predict(model, newdata = . ) function etc.
}
}
