% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqER.R
\name{seqER}
\alias{seqER}
\title{Computes sequential evidence ratios}
\usage{
seqER(ic, mod1, mod2, nmin, id = NULL)
}
\arguments{
\item{ic}{Indicates whether to use the aic or the bic.}

\item{mod1}{A model of class \code{lm} or \code{lmerMod}.}

\item{mod2}{A model of class \code{lm} or \code{lmerMod} (of the same class of mod1).}

\item{nmin}{Minimum sample size from which start to compute sequential evidence ratios.}

\item{id}{If applicable (i.e., repeated measures), name of the "id" column of your
dataframe, in character string.}
}
\description{
Computes sequential evidence ratios, either based on the AIC or the BIC.
Supported models currently include \code{lm} or \code{merMod} models.
When data involve repeated measures (and so multiple lines per subject),
a column indicating the subject "id" should be provided to the \code{id} argument.
If nothing is passed to the \code{id} argument, \code{seqER} will suppose
that there is only one observation (i.e., one line) per subject.
}
\examples{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + disp, mtcars)
seq_mtcars <- seqER(ic = aic, mod1, mod2, nmin = 10)

# Example with repeated measures
library(lme4)
data(sleepstudy)
mod1 <- lmer(Reaction ~ Days + (1|Subject), sleepstudy)
mod2 <- lmer(Reaction ~ Days + I(Days^2) + (1|Subject), sleepstudy)
seqER(ic = aic, mod1, mod2, nmin = 10, id = "Subject")

}
\seealso{
\code{\link{seqERboot}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
