% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{nonIntrinsic_Transformation_Elliptical_Tubes}
\alias{nonIntrinsic_Transformation_Elliptical_Tubes}
\title{Non-Intrinsic Transformation Between Two ETReps}
\usage{
nonIntrinsic_Transformation_Elliptical_Tubes(
  tube1,
  tube2,
  type = "sizeAndShapeAnalysis",
  numberOfSteps = 4,
  plotting = TRUE,
  colorBoundary = "blue",
  add = FALSE
)
}
\arguments{
\item{tube1}{List containing details of the first ETRep.}

\item{tube2}{List containing details of the second ETRep.}

\item{type}{String defining the type of analysis as sizeAndShapeAnalysis or shapeAnalysis}

\item{numberOfSteps}{Integer, number of transformation steps.}

\item{plotting}{Logical, enables visualization during transformation (default is TRUE).}

\item{colorBoundary}{String defining the color of the e-tube}

\item{add}{Logical, enables overlay plotting}
}
\value{
List containing intermediate ETReps.
}
\description{
Performs a non-intrinsic transformation from one ETRep to another. This approach is inspired by robotic arm transformations and does not account for the Relative Curvature Condition (RCC).
}
\examples{
\donttest{
# Load tubes
data("tube_A")
data("tube_B")
numberOfSteps <- 10
transformation_Tubes<-
  nonIntrinsic_Transformation_Elliptical_Tubes(
    tube1 = tube_A,tube2 = tube_B,
    numberOfSteps = numberOfSteps,
    plotting = FALSE)
# Plotting
for (i in 1:length(transformation_Tubes)) {
  plot_Elliptical_Tube(tube = transformation_Tubes[[i]],
  plot_frames = FALSE,plot_skeletal_sheet = FALSE
  ,plot_r_project = FALSE,
  plot_r_max = FALSE,
  add = FALSE)
}
}
}
\references{
Taheri, M., Pizer, S. M., & Schulz, J. (2024). "The Mean Shape under the Relative Curvature Condition." arXiv.
\doi{10.48550/arXiv.2404.01043}

Taheri Shalmani, M. (2024). "Shape Statistics via Skeletal Structures." University of Stavanger.
\doi{10.13140/RG.2.2.34500.23685}
}
