% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indic.R
\name{indic}
\alias{indic}
\title{Issue of an Early Warning}
\usage{
indic(evi, cut, cases)
}
\arguments{
\item{evi}{numeric vector - object (obtained from the evi function and stored as ev) that corresponds to the relative change in the standard deviation.}

\item{cut}{threshold value (0 <= c <= 0.5) for issuing an early warning. If evi >= c an early warning is issued and otherwise is not.}

\item{cases}{numeric vector with the number of new cases per unit of time (i.e., daily).}
}
\value{
A vector of 0s and 1s is produced, where a 1 (Index = 1) is recorded when an early warning is issued and a 0 (Index = 0) when an early warning is not issued.
}
\description{
This function produces the early warning signal (Index).
}
\examples{
data("Italy")
cases = mova(cases = Italy$Cases, r_a = 7)
roll = rollsd(cases = cases, lag_t = 7)
ev = evi(rollsd = roll)
ind=indic(evi = ev, cut = 0.01, cases = cases)

}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
