\name{EWGoF-package}
\alias{EWGoF-package}
\alias{EWGoF}
\docType{package}
\title{Goodness-of-Fit Tests for the Exponential and Two-Parameter Weibull Distributions}
\description{
This package contains a large number of the goodness-of-fit tests for the Exponential and Weibull distributions classified into families: the tests based on the empirical distribution function, the tests based on the probability plot, the tests based on the normalized spacings, the tests based on the Laplace transform and the likelihood based tests ...
}
\details{
\tabular{ll}{
Package: \tab EWGoF\cr
Type: \tab Package\cr
Version: \tab 2.2\cr
Date: \tab 2017-09-08\cr
License: \tab GPL (>=2.0)\cr
Imports: \tab Rcpp (>= 0.10.3) \cr
LazyLoad: \tab yes\cr
LinkingTo: \tab Rcpp\cr
}
Computes the p-value of the chosen test statistic, the value of the observed statistic and an estimation of the distribution parameters (either the parameter of the Exponential distribution or the shape and the scale Weibull parameters). }
\author{
Meryam Krit
Maintainer: Meryam Krit <meryam.krit@gmail.com>
}
\references{
\itemize{
\item D'Agostino R.B. and Stephens M.A., \emph{Goodness-of-fit techniques}, Marcel Dekker, 1986.

\item Henze N. and Meintanis S.G., Recent and classical tests for exponentiality: a partial review with comparisons, \emph{Metrika}, 61, 29-45, 2005.

\item Liao M. and Shimokawa T., A new goodness-of-fit test for type-I extreme-value and 2-parameter Weibull distributions with estimated parameters, \emph{Journal of Statistical Computation and Simulation}, 64 (1), 23-48, 1999.

\item Tiku M.L. and Singh M., Testing the two-parameter Weibull distribution, \emph{Communications in Statistics}, 10, 907-918, 1981.

\item Mann N.R., Scheuer E.M. and Fertig K.W., A new goodness-of-fit test for the two-parameter Weibull or extreme-value distribution, \emph{Communications in Statistics}, 2, 383-400, 1973.

\item Lockhart R.A., O'Reilly F. and Stephens M.A., Tests for the extreme-value and Weibull distributions based on normalized spacings, \emph{Naval Research Logistics Quarterly}, 33, 413-421, 1986.

\item Cabana A. and Quiroz A.J., Using the empirical moment generating function in testing the Weibull and type 1 Extreme Value distributions, \emph{ Test}, 14(2), 417-431, 2005.

\item Krit M., Goodness-of-fit tests for the Weibull distribution based on the Laplace transform, \emph{J-SFdS}, 2014.}
}

\keyword{EWGoF}
