\name{binary_model}
\alias{binary_model}
\title{
  Wrapper for a binary executable for non-parallel simulations}
\description{
  This function enables to link a binary executable to a \code{R} function.
}
\usage{
  binary_model(command)}
\arguments{
  \item{command}{
	a character string indicating the command to launch the executable on your system.}
}
\details{
  A binary executable used with \code{binary_model} has to be placed in the current directory of the \code{R} session.
  It further has to respect several constraints: it has to read the seed for its pseudo-random number generator and the model parameters in a file "input", and it must write the summary statistic in a file "output".
  The file "input" will be generated by the wrapper \code{binary_model} in the current directory of the \code{R} session, and the wrapper will read the file "output" generated by the binary executable.
  In the file "input", the first line contains the seed, and each subsequent line contains one model parameter value.
  In the file "output", each summary statistic should be separated by a space or a tab separation.
  This wrapper should be used for use with a single core of the computer. If the user wishes to use several cores of the computer, the wrapper \code{\link{binary_model_cluster}} should be used.
  Note that the files "input" and "output" are deleted by the wrapper at the end of the function.
}
\value{
	A \code{R} function wrapping the binary executable, to be used with the \code{EasyABC} functions.
}
%\references{}
\author{Franck Jabot, Thierry Faure and Nicolas Dumoulin}
\seealso{
  \code{\link{binary_model_cluster}}, \code{\link{ABC_rejection}}, \code{\link{ABC_sequential}}, \code{\link{ABC_mcmc}}
}
\examples{
  \dontrun{%
    ## artificial example to show how to use the binary_model function with an executable "My_Executable"
    ABC_rej<-ABC_rejection(model=binary_model("./My_Executable"), prior=..., n_cluster=1,...)

    # NB: on windows, "My_Executable" should be of the form "My_Executable.exe" :
    ABC_rej<-ABC_rejection(model=binary_model("./My_Executable.exe"), prior=..., n_cluster=1,...)
  }
}
\keyword{abc}
\keyword{model}
\keyword{inference}

