% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.NDVI.R
\name{eco.NDVI}
\alias{eco.NDVI}
\title{Generating atmospherically corrected NDVI and MSAVI2 images for
temporal series of Landsat 5 and 7}
\usage{
eco.NDVI(tab, correct = c("COST", "DOS"), method = c("NDVI", "MSAVI2"),
  landsat = c("LT5", "LT7.L", "LT7.H"), datatype = c("FLT4S", "FLT8S",
  "INT4U", "INT4S", "INT2U", "INT2S", "INT1U", "INT1S", "LOG1S"))
}
\arguments{
\item{tab}{Data frame with 7 columns: The date of the images
(format: YYYY/MM/DD), the sun elevation (both values could be extracted
from Landsat headers), the name of the band 4, the name of the band 3,
the starting haze value of the band 4, the starting haze value of
the band 3, and the name of the output file. Each row corresponds to
an image of different date.}

\item{correct}{Correction method ("COST", "DOS").}

\item{method}{Vegetation index ("NDVI", "MSAVI2").}

\item{landsat}{satellite data source ("LT5" for landsat 5,
"LT7.L" for landsat 7 low gain and "LT7.H" for landsat 7 high gain).}

\item{datatype}{type of data, see \code{\link[raster]{dataType}}.
Default "FLT4S".}
}
\description{
Generating atmospherically corrected NDVI and MSAVI2 images for
temporal series of Landsat 5 and 7
}
\examples{
\dontrun{

require(raster)

data(eco.test)

temp <-list()

# we create 4 simulated rasters for the data included in the object tab:

for(i in 1:4) {
temp[[i]] <- runif(19800, 0, 254)
temp[[i]] <- matrix(temp[[i]], 180, 110)
temp[[i]] <- raster::raster(temp[[i]])
extent(temp[[i]])<-c(3770000, 3950000, 6810000, 6920000)
}

writeRaster(temp[[1]], "20040719b4.tif", overwrite=T)
writeRaster(temp[[2]], "20040719b3.tif", overwrite=T)
writeRaster(temp[[3]], "20091106b4.tif", overwrite=T)
writeRaster(temp[[4]], "20091106b3.tif", overwrite=T)

# Computing NDVI images:

eco.NDVI(tab, "COST", "NDVI", "LT5")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

