% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.rarefact.R
\name{eco.rarefact}
\alias{eco.rarefact}
\title{Multiple rarefaction estimates via bootstrap for ecogen genetic data frames}
\usage{
eco.rarefact(eco, x, nrep = 99, mode = "Ae", type = NA)
}
\arguments{
\item{eco}{ecogen object.}

\item{x}{The name of the S slot column with the groups for
the rarefaction analysis.}

\item{nrep}{Number of repetitions for the bootstrap estimates.}

\item{mode}{Mode passed to the function \code{\link[gstudio]{rarefaction}}.
Default: "Ae".}

\item{type}{Argument passed to \code{\link[gstudio]{locus}}. If not
provided, the program set it as "separated" for data as microsatellites
or individual haplotypes, and "aflp" for presence - absence data.}
}
\value{
ESTIMATES BY LOCI the estimates by loci and the 95\% CI.

OVERALL ESTIMATES the overall estimates and the 95\% CI.
}
\description{
This program computes multiple-loci confidence intervals
of 95\% by bootstrap,  passing arguments to the functions
\code{\link{rarefaction}} and \code{\link{genetic_diversity}}.
The estimates are calculated by group. The metrics which could be
estimated are specified in \code{\link{genetic_diversity}}.
A bootstrap over groups also is performed. In the case of Ae, the mean
is replaced by the harmonic mean.
}
\examples{
\dontrun{

data(eco.test)
Ae.raref <- eco.rarefact(eco,"structure", nrep = 50)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

