% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.rankplot.R
\docType{methods}
\name{eco.rankplot}
\alias{eco.rankplot}
\alias{eco.rankplot,eco.lsa,missing,missing-method}
\alias{eco.rankplot,eco.lsa-method}
\alias{eco.rankplot,factor,dataframeORmatrix,missing-method}
\alias{eco.rankplot,factor-method}
\alias{eco.rankplot,genetic-method}
\alias{eco.rankplot,numeric,dataframeORmatrix,missing-method}
\alias{eco.rankplot,numeric-method}
\title{Rankplot graphs}
\usage{
eco.rankplot(input, XY, xlabel = NULL, ylabel = NULL, title = NULL,
  legendlabel = NULL, background = c("grey", "white"), ...)

\S4method{eco.rankplot}{eco.lsa,missing,missing}(input, XY, xlabel, ylabel,
  title, legendlabel, background = c("grey", "white"), significant = TRUE,
  rescaled = FALSE, ns = NULL)

\S4method{eco.rankplot}{numeric,dataframeORmatrix,missing}(input, XY, xlabel,
  ylabel, title, legendlabel, background = c("grey", "white"))

\S4method{eco.rankplot}{factor,dataframeORmatrix,missing}(input, XY, xlabel,
  ylabel, title, legendlabel, background = c("grey", "white"))
}
\arguments{
\item{input}{Numeric/factor variable.}

\item{XY}{Data frame or matrix with X-Y coordinates.}

\item{xlabel}{Optional label for x axis.}

\item{ylabel}{Optional label for y axis.}

\item{title}{Optional title label.}

\item{legendlabel}{Optional legend label.}

\item{background}{color of the background ("grey" or "white")-}

\item{...}{Additional elements to the generic.}

\item{significant}{should be colored only the individuals with significant 
result?. This argument can be used with \code{\link{eco.lsa}} results. 
Default TRUE}

\item{rescaled}{rescale values to [-1, 1] range?}

\item{ns}{color for non significant individuals, when significant = TRUE.
This argument can be used with \code{\link{eco.lsa}} results.}
}
\description{
This function generates a plot for a numeric or
factor variable. A data frame/matrix with XY coordinates is required.
The X and Y axes in the plot correspond 
to the rank of the X and Y coordinates, respectively.
}
\examples{
\dontrun{
data(eco3)

# The data set eco3 has  50 points in two sites, 
# but they are not visible in a usual X-Y plot 
due to the small distance among them

var <- eco3[["P"]][,1]
plot(eco3[["XY"]], col = var)
x <- sample(1:100, 30)
y <- sample(1:100, 30)

# in a rankplot graph, the inter-individual distances are
# reduced to a single scale
rankeco3 <- eco.rankplot(var, eco3[["XY"]])
rankeco3

# the rankplot method support the use of ggplot2 syntax
rankeco3 <- rankeco3 + theme_bw() + theme(legend.position="none")
rankeco3
}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

