% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{ecogen2gstudio}
\alias{ecogen2gstudio}
\alias{gstudio2ecogen}
\title{Conversion from ecogen to gstudio and gstudio to ecogen}
\usage{
ecogen2gstudio(from, type = c("codominant", "dominant"))

gstudio2ecogen(from, ID = "ID", lat = "Latitude", lon = "Longitude",
  struct = NULL)
}
\arguments{
\item{from}{Input object of class "ecogen" or "gstudio" (depending the direction of conversion)}

\item{type}{The type of data:  "codominant" (for codominant data); "dominant" for presence - absence data.}

\item{ID}{name of the column with ID (default "ID")}

\item{lat}{name of the column with latitude (default "Latitude")}

\item{lon}{name of the column with longitude (default "Longitude")}

\item{struct}{vector with name of the columns with structures (default NULL)}
}
\description{
These functions converts the genetic 
data of an ecogen object in a gstudio data frame or viceversa.

Conversion from gstudio to ecogen
}
\examples{

\dontrun{

data(eco.test)
togstudio <- ecogen2gstudio(eco, type = "codominant")
togstudio
toeco <- gstudio2ecogen(togstudio, ID = "ID", lat = "Latitude", 
lon = "Longitude", struct = "pop")
toeco
# as ID, Latitude and Longitude are column names in the <togstudio> data frame 
# (that match default parameter values for gstudio2ecogen), 
# the latter is identical to this:
toeco <- gstudio2ecogen(togstudio, struct = "pop")
toeco
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
