% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sizeratio_null.R
\name{size_null_model}
\alias{size_null_model}
\title{Size Ratio}
\usage{
size_null_model(speciesData, algo = "size_uniform", metric = "var_ratio",
  nReps = 1000, saveSeed = FALSE, algoOpts = list(),
  metricOpts = list(), suppressProg = FALSE)
}
\arguments{
\item{speciesData}{a data vector in which each entry is the measured trait (such as body size or flowering date) for each species in the assemblage.}

\item{algo}{the algorithm to use, must be "size_uniform", "size_uniform_user", "size_source_pool", "size_gamma".}

\item{metric}{the metric used to caluclate the null model: choices are "min_diff", "min_ratio", "var_diff", "var_ratio"; default is "var_ratio".}

\item{nReps}{the number of replicate null assemblages to create; default is 1000 replicates.}

\item{saveSeed}{TRUE or FALSE. If TRUE the current seed is saved so the simulation can be repeated; default is FALSE.}

\item{algoOpts}{a list containing all the options for the specific algorithm you want to use.  Must match the algorithm given in the `algo` argument.}

\item{metricOpts}{a list containing all the options for the specific metric you want to use.  Must match the metric given in the `metric` argument.}

\item{suppressProg}{TRUE or FALSE. If true, display of the progress bar in the console is suppressed; default is FALSE. This setting is useful for creating markdown documents with `knitr`.}
}
\description{
Create a Size Ratio null model
}
\examples{
\dontrun{
## Run the null model
rodentMod <- size_null_model(dataRodents)
## Summary and plot info
summary(rodentMod)
plot(rodentMod,type="hist")
plot(rodentMod,type="size")

##  Uniform Size model with user inputs
rodentMod2 <- size_null_model(dataRodents,algo="size_uniform_user",
algoOpts = list(userLow = 3,userHigh=15))
summary(rodentMod2)
plot(rodentMod2,type="hist")
plot(rodentMod2,type="size")

### Source pool model

rodentMod_sp <- size_null_model(dataRodents,algo="size_source_pool",
algoOpts = list(sourcePool = runif(dim(dataRodents)[1],1,15)))

summary(rodentMod_sp)
plot(rodentMod_sp,type="hist")
plot(rodentMod_sp,type="size")

}
}

